/*
 * Decompiled with CFR 0.152.
 */
package lib.toma.animations.engine.frame;

import java.util.HashMap;
import java.util.Map;
import lib.toma.animations.api.AnimationStage;
import lib.toma.animations.api.IAnimation;
import lib.toma.animations.api.IFrameProviderInstance;
import lib.toma.animations.api.IKeyframe;
import lib.toma.animations.api.IKeyframeProvider;
import lib.toma.animations.api.event.IAnimationEvent;
import net.minecraft.client.Minecraft;

public final class FrameProviderInstance
implements IFrameProviderInstance {
    private final IKeyframeProvider frameProvider;
    private final Map<AnimationStage, Integer> frameCache;
    private byte eventIndex;

    FrameProviderInstance(IKeyframeProvider frameProvider) {
        this.frameProvider = frameProvider;
        this.frameCache = new HashMap<AnimationStage, Integer>();
        this.frameProvider.initCache(this.frameCache);
    }

    public static IFrameProviderInstance newInstance(IKeyframeProvider provider) {
        return new FrameProviderInstance(provider);
    }

    @Override
    public boolean blocksStageAnimation(AnimationStage stage) {
        return !this.frameCache.containsKey(stage);
    }

    @Override
    public IKeyframe getCurrentFrame(AnimationStage stage, float animationProgress) {
        int index = this.frameCache.get(stage);
        if (this.frameProvider.shouldAdvance(stage, animationProgress, index)) {
            this.frameCache.put(stage, ++index);
        }
        return this.frameProvider.getCurrentFrame(stage, animationProgress, index);
    }

    @Override
    public IKeyframe getPreviousFrame(AnimationStage stage) {
        return this.frameProvider.getOldFrame(stage, this.frameCache.get(stage));
    }

    @Override
    public void onAnimationProgressed(float progress, float progressOld, IAnimation source) {
        IAnimationEvent[] events = this.frameProvider.getEvents();
        this.invokeEventsRecursive(events, source, progress, progressOld);
    }

    private void invokeEventsRecursive(IAnimationEvent[] events, IAnimation source, float progress, float progressOld) {
        if (this.eventIndex >= events.length) {
            return;
        }
        IAnimationEvent event = events[this.eventIndex];
        float eventDispatchTarget = event.invokeAt();
        if (progress >= eventDispatchTarget && progressOld < eventDispatchTarget) {
            this.eventIndex = (byte)(this.eventIndex + 1);
            event.dispatch(Minecraft.func_71410_x(), source);
            this.invokeEventsRecursive(events, source, progress, progressOld);
        }
    }
}

